#!/bin/bash

dir=`dirname $0`;
if [ x$dir = "x." ]
then
    dir=`pwd`
fi
base=`basename $0`;

homedir=/root
libdirectory=/usr/lib/x86_64-linux-gnu/sane
configdir=/etc/sane.d
rulesdir=/etc/udev/rules.d

p=sane.katusha-m335-1.0-27.x86-64

if [ "$HOME" != "$homedir" ]
then
        echo "Need to be a 'root' user."
        exit 0;
fi

if [ "$1" == "-i" ]
then
	echo "Checking for the sane support on the system."
        if [ -d "$libdirectory" ]
        then
                binary=1

                function untar_payload()
                {
                        match=$(grep --text --line-number '^PAYLOAD:$' $0 | cut -d ':' -f 1)
                        payload_start=$((match + 1))
                        if [[ $binary -ne 0 ]]; then
                                tail -n +$payload_start $0 | tar -zxvf -
                        fi
                }

                read -p "Install Katusha M335 scanner driver package $p? Yes (y) or No (n) : " ans
                if [[ "${ans}" == "y" || "${ans}" == "Yes" ]]
                then
                        echo "Preparing to install the Katusha M335 scanner driver."
                        untar_payload
                        dpkg -i $p/$p.deb
                        ln -s $libdirectory/libsane-katusham335.so.1.0.27 $libdirectory/libsane-katusham335.so
                        ln -s $libdirectory/libsane-katusham335.so.1.0.27 $libdirectory/libsane-katusham335.so.1
                        product=`grep katusham335 $configdir/dll.conf`
                        if [ "$product" == "" ]
                        then
                                echo katusham335 >> $configdir/dll.conf
                        fi
			chmod a+rw $rulesdir/65-katusham335.rules
                        echo "Installation of the Katusha M335 scanner driver package $p is completed."
                        exit 0;
                else
                        echo "Installation cancelled."
                        exit 0;
                fi
        else
                echo "There is no sane support on your system. Hence Katusha M335 scanner driver cannot be installed."
                exit 0;
        fi
elif [ "$1" == "-u" ]
then
        echo "Remove the $p?"
        echo "Yes (y) or No (n)"
        read Choice
        if [ $Choice == "y" ]
        then
                dpkg -r $p
                rm $libdirectory/libsane-katusham335.so
                rm $libdirectory/libsane-katusham335.so.1
                tmpvar=`sed -i '/katusham335/d' $configdir/dll.conf`
                echo "Katusha M335 scanner driver package $p uninstalled from the system"
                exit 0;
        else
                exit 0;
        fi
else
        echo "Invalid arguments"
        echo "Installation  :   ./installer_x86_64.sh -i"
        echo "Uninstallation:   ./installer_x86_64.sh -u"
        exit 0;
fi
PAYLOAD:
#!/bin/bash

dir=`dirname $0`;
if [ x$dir = "x." ]
then
    dir=`pwd`
fi
base=`basename $0`;

homedir=/root
libdirectory=/usr/lib/x86_64-linux-gnu/sane
configdir=/etc/sane.d
rulesdir=/etc/udev/rules.d

p=sane.katusha-m335-1.0-27.x86-64

if [ "$HOME" != "$homedir" ]
then
        echo "Need to be a 'root' user."
        exit 0;
fi

if [ "$1" == "-i" ]
then
	echo "Checking for the sane support on the system."
        if [ -d "$libdirectory" ]
        then
                binary=1

                function untar_payload()
                {
                        match=$(grep --text --line-number '^PAYLOAD:$' $0 | cut -d ':' -f 1)
                        payload_start=$((match + 1))
                        if [[ $binary -ne 0 ]]; then
                                tail -n +$payload_start $0 | tar -zxvf -
                        fi
                }

                read -p "Install Katusha M335 scanner driver package $p? Yes (y) or No (n) : " ans
                if [[ "${ans}" == "y" || "${ans}" == "Yes" ]]
                then
                        echo "Preparing to install the Katusha M335 scanner driver."
                        untar_payload
                        dpkg -i $p/$p.deb
                        ln -s $libdirectory/libsane-katusham335.so.1.0.27 $libdirectory/libsane-katusham335.so
                        ln -s $libdirectory/libsane-katusham335.so.1.0.27 $libdirectory/libsane-katusham335.so.1
                        product=`grep katusham335 $configdir/dll.conf`
                        if [ "$product" == "" ]
                        then
                                echo katusham335 >> $configdir/dll.conf
                        fi
			chmod a+rw $rulesdir/65-katusham335.rules
                        echo "Installation of the Katusha M335 scanner driver package $p is completed."
                        exit 0;
                else
                        echo "Installation cancelled."
                        exit 0;
                fi
        else
                echo "There is no sane support on your system. Hence Katusha M335 scanner driver cannot be installed."
                exit 0;
        fi
elif [ "$1" == "-u" ]
then
        echo "Remove the $p?"
        echo "Yes (y) or No (n)"
        read Choice
        if [ $Choice == "y" ]
        then
                dpkg -r $p
                rm $libdirectory/libsane-katusham335.so
                rm $libdirectory/libsane-katusham335.so.1
                tmpvar=`sed -i '/katusham335/d' $configdir/dll.conf`
                echo "Katusha M335 scanner driver package $p uninstalled from the system"
                exit 0;
        else
                exit 0;
        fi
else
        echo "Invalid arguments"
        echo "Installation  :   ./installer_x86_64.sh -i"
        echo "Uninstallation:   ./installer_x86_64.sh -u"
        exit 0;
fi
